/*
 * Decompiled with CFR 0.152.
 */
package com.k2fsa.sherpa.onnx;

import com.k2fsa.sherpa.onnx.SpeechSegment;
import com.k2fsa.sherpa.onnx.VadModelConfig;

public class Vad {
    private long ptr = 0L;

    public Vad(VadModelConfig vadModelConfig) {
        this.ptr = this.newFromFile(vadModelConfig);
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public void release() {
        if (this.ptr == 0L) {
            return;
        }
        this.delete(this.ptr);
        this.ptr = 0L;
    }

    public void acceptWaveform(float[] fArray) {
        this.acceptWaveform(this.ptr, fArray);
    }

    public boolean empty() {
        return this.empty(this.ptr);
    }

    public void pop() {
        this.pop(this.ptr);
    }

    public void clear() {
        this.clear(this.ptr);
    }

    public void reset() {
        this.reset(this.ptr);
    }

    public void flush() {
        this.flush(this.ptr);
    }

    public SpeechSegment front() {
        Object[] objectArray = this.front(this.ptr);
        int n = (Integer)objectArray[0];
        float[] fArray = (float[])objectArray[1];
        return new SpeechSegment(n, fArray);
    }

    public boolean isSpeechDetected() {
        return this.isSpeechDetected(this.ptr);
    }

    private native void delete(long var1);

    private native long newFromFile(VadModelConfig var1);

    private native void acceptWaveform(long var1, float[] var3);

    private native boolean empty(long var1);

    private native void pop(long var1);

    private native void clear(long var1);

    private native Object[] front(long var1);

    private native boolean isSpeechDetected(long var1);

    private native void reset(long var1);

    private native void flush(long var1);

    static {
        System.loadLibrary("sherpa-onnx-jni");
    }
}

