/*
 * Decompiled with CFR 0.152.
 */
package com.k2fsa.sherpa.onnx;

import com.k2fsa.sherpa.onnx.EndpointRule;

public class EndpointConfig {
    private final EndpointRule rule1;
    private final EndpointRule rule2;
    private final EndpointRule rule3;

    private EndpointConfig(Builder builder) {
        this.rule1 = builder.rule1;
        this.rule2 = builder.rule2;
        this.rule3 = builder.rule3;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EndpointRule getRule1() {
        return this.rule1;
    }

    public EndpointRule getRule2() {
        return this.rule2;
    }

    public EndpointRule getRule3() {
        return this.rule3;
    }

    public static class Builder {
        private EndpointRule rule1 = EndpointRule.builder().setMustContainNonSilence(false).setMinTrailingSilence(2.4f).setMinUtteranceLength(0.0f).build();
        private EndpointRule rule2 = EndpointRule.builder().setMustContainNonSilence(true).setMinTrailingSilence(1.4f).setMinUtteranceLength(0.0f).build();
        private EndpointRule rule3 = EndpointRule.builder().setMustContainNonSilence(false).setMinTrailingSilence(0.0f).setMinUtteranceLength(20.0f).build();

        public EndpointConfig build() {
            return new EndpointConfig(this);
        }

        public Builder setRule1(EndpointRule endpointRule) {
            this.rule1 = endpointRule;
            return this;
        }

        public Builder setRule2(EndpointRule endpointRule) {
            this.rule2 = endpointRule;
            return this;
        }

        public Builder setRul3(EndpointRule endpointRule) {
            this.rule3 = endpointRule;
            return this;
        }
    }
}

