/*
 * Decompiled with CFR 0.152.
 */
package com.k2fsa.sherpa.onnx;

import com.k2fsa.sherpa.onnx.AudioEvent;
import com.k2fsa.sherpa.onnx.AudioTaggingConfig;
import com.k2fsa.sherpa.onnx.OfflineStream;

public class AudioTagging {
    private long ptr = 0L;

    public AudioTagging(AudioTaggingConfig audioTaggingConfig) {
        this.ptr = this.newFromFile(audioTaggingConfig);
    }

    public OfflineStream createStream() {
        long l = this.createStream(this.ptr);
        return new OfflineStream(l);
    }

    public AudioEvent[] compute(OfflineStream offlineStream) {
        return this.compute(offlineStream, -1);
    }

    public AudioEvent[] compute(OfflineStream offlineStream, int n) {
        Object[] objectArray = this.compute(this.ptr, offlineStream.getPtr(), n);
        AudioEvent[] audioEventArray = new AudioEvent[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            String string = (String)objectArray2[0];
            int n2 = (Integer)objectArray2[1];
            float f = ((Float)objectArray2[2]).floatValue();
            audioEventArray[i] = new AudioEvent(string, n2, f);
        }
        return audioEventArray;
    }

    protected void finalize() throws Throwable {
        this.release();
    }

    public void release() {
        if (this.ptr == 0L) {
            return;
        }
        this.delete(this.ptr);
        this.ptr = 0L;
    }

    private native void delete(long var1);

    private native long newFromFile(AudioTaggingConfig var1);

    private native long createStream(long var1);

    private native Object[] compute(long var1, long var3, int var5);

    static {
        System.loadLibrary("sherpa-onnx-jni");
    }
}

